%%%%%%% Before running this program, please make sure that you install
%%%%%%% SeDuZi, SOSTOOLS, and multipoly toolboxes correctly. 

tic;
clear;


%%% Input your system parameters here %%%
A=[0.9500    1.0000 ;
         0    1.0100]; % A: A matrix
C=[0.1 1]; % C: C matrix
W=[0.2 0;0 0.2]; % W: system noise covariance
Z=eye(2); % Z: weighting matrix
V=0.3; % V: measurement noise covariance
lambda=5; % lambda: communication price for one transmission
mu_0=[0;0]; % mu_0: initial state


%%% Input D_2, phi, and d here %%%
high_degree=6; % high_degree: the highest degree in the polynomial
phi=10; % phi: check Algorithm 6.3.
d=lambda*0.25; % d: check Algorithm 6.3

%%% Ajust the size of x according to the system dimension %%%
pvar x1 x2 J; 
x=[x1;x2];

n=length(A);

% Kalman filter design
X=dare(A',C',W,V);
L=X*C'/(C*X*C'+V);
Q=(eye(n)-L*C)*X;
Y=L*(C*A*Q*A'*C'+C*W*C'+V)*L';
save sys_par.mat A C V W L Y lambda Q Z mu_0;


s(1,:)=ones(1,high_degree);
for j=1:high_degree
    s(2,j)=j+1;
    if n>3
        error('Have not figured out the rule for producing monomials with higher than 3 order');
    else if n==3
        s(3,j)=(j+1)*(j+2)/2;
        end
    end
end
 
[moment cm]=one_step_expect_monomials(high_degree,x,A,Y);%load data.mat;%
toc

%%% SOSTOOLS algorithm %%%
% initialization
prog=sosprogram(x);
% define variable
prog=sosdecvar(prog,J);

[prog,f]=sospolyvar(prog,monomials(x,2:2:high_degree),'wscoeff');
% define inequalities
term_num=length(f.coefficient);
E_f=0;
E_f_0=0;
for i=1:term_num
    coefficient_tend=polynomial(1,[f.degmat(i,1:term_num) zeros(1,n)],f.varname,[1 1]);
    pos_tend=position(f.degmat(i,term_num+1:term_num+n),s);
    row_tend=ceil(pos_tend/57);
    E_f=E_f+coefficient_tend*moment(row_tend,pos_tend-57*(row_tend-1));
    E_f_0=E_f_0+coefficient_tend*cm(pos_tend);
end

% constraints
step_inv=(x'*Z*x/d)^phi+1;

cs1=step_inv*(J+f-(E_f+x'*Z*x))-(E_f+x'*Z*x)*(step_inv-1)*(d-x'*Z*x);
cs2=step_inv*(J+f-(E_f_0+lambda))+(E_f_0+lambda)*(d-x'*Z*x);
prog=sosineq(prog,cs1);
prog=sosineq(prog,cs2);

% define objective
prog=sossetobj(prog,J);
% call solver
prog=sossolve(prog);
% get solution
J_overline=sosgetsol(prog,J)+trace(Q*Z)
fs=sosgetsol(prog,f);

%%% Compute the polynomial event trigger here %%%
Ef0=0;
Ef=0;
for i=1:term_num
    coefficient_tend=polynomial(1,[f.degmat(i,1:term_num) zeros(1,n)],f.varname,[1 1]);
    c_t=sosgetsol(prog,coefficient_tend);
    pos_tend=position(f.degmat(i,term_num+1:term_num+n),s);
    row_tend=ceil(pos_tend/57);
    Ef=Ef+c_t*moment(row_tend,pos_tend-57*(row_tend-1));
    Ef0=Ef0+c_t*cm(pos_tend);
end
poly_event_trigger=Ef-Ef0+x'*Z*x-lambda
save eve_dec.mat Ef0 Ef J_overline high_degree;